//
//  main.cpp
//  fp64
//
//  Created by Bob Delaney on 11/30/18.
//  Copyright © 2018 Bob Delaney. All rights reserved.
//

#include <iostream>
#include <time.h>       /* time */
#include "fp.hpp"
#include "myGammaFunctions.hpp"

extern long decPrec;

int main(int argc, const char * argv[])
{
    fp          x, y, z, a, b, c, ten=10;
    long        i, aInt, p, myUserPrec, prec, r, xInt;
    double      xd;
    clock_t     time;
    
    myUserPrec = 0;
    while(myUserPrec<3)
    {
        cout << "userPrec: ";
        cin >> myUserPrec;
    }
    setUserPrec(myUserPrec);
    setOutPrec(myUserPrec);
    
again:
    x = -1;
    while(isItInteger(x) && !x.i.s)
    {
        // don't allow negative integers
        cout << "x: ";
        cin >> x;
    }
    time = clock();
    Gamma(z, x+1);
    time = clock() - time;
    cout << "x! = " << z << endl;
    cout << "time = " << (double)time / CLOCKS_PER_SEC << " sec" << endl << endl;
    
    y = z - x*Gamma(x);
    //cout << "check = " << y << endl;
    if(y==0)
        goto again;;
    b = power(ten, decPrec);
    b = z / b;
    b = abs(b/y);
    prec = decPrec + to_long(log(b)/log(ten));
    if(prec<decPrec)
        cout << "actual decPrec = " << prec << endl << endl;
    goto again;
    return 0;
    
}
